/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.client;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import slimeknights.tconstruct.shared.block.SlimeType;

public class SlimeColorizer {
    private static final Map<SlimeType, int[]> COLOR_MAP = (Map)class_156.method_654(new EnumMap(SlimeType.class), map -> {
        for (SlimeType type : SlimeType.values()) {
            map.put(type, new int[65536]);
        }
    });
    public static final float LOOP = 256.0f;
    public static final class_2338 LOOP_OFFSET = class_2338.method_49637((double)128.0, (double)0.0, (double)128.0);

    public static void setGrassColor(SlimeType type, int[] colors) {
        COLOR_MAP.put(type, colors);
    }

    public static int getColor(SlimeType type, int x, int z) {
        return SlimeColorizer.getColor(COLOR_MAP.get((Object)type), x, z);
    }

    public static int getColorForPos(class_2338 pos, SlimeType type) {
        return SlimeColorizer.getColor(type, pos.method_10263(), pos.method_10260());
    }

    private static int getColor(int[] buffer, int posX, int posZ) {
        float z;
        float x = Math.abs((256.0f - (float)Math.abs(posX) % 512.0f) / 256.0f);
        if (x < (z = Math.abs((256.0f - (float)Math.abs(posZ) % 512.0f) / 256.0f))) {
            float tmp = x;
            x = z;
            z = tmp;
        }
        return buffer[(int)(x * 255.0f) << 8 | (int)(z * 255.0f)];
    }

    public static int getColorStatic(SlimeType type) {
        return type.getDefaultFoliageColor();
    }
}

